<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

$response = ['status' => 'error', 'message' => 'No files uploaded'];
$upload_dir = 'images/';
$file_paths = [];

// Create directory if it doesn't exist
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

if (!empty($_FILES['files'])) {
    foreach ($_FILES['files']['tmp_name'] as $key => $tmp_name) {
        $file_name = basename($_FILES['files']['name'][$key]);
        $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
        $new_file_name = uniqid() . '.' . $file_ext;
        $file_path = $upload_dir . $new_file_name;

        if (move_uploaded_file($tmp_name, $file_path)) {
            $file_paths[] = $file_path;
        }
    }

    if (!empty($file_paths)) {
        $response = [
            'status' => 'success',
            'message' => 'Files uploaded successfully',
            'file_paths' => $file_paths
        ];
    } else {
        $response['message'] = 'Failed to move uploaded files';
    }
}

echo json_encode($response);
?>